#ifndef SIGMASK_H
#define SIGMASK_H

class SigMask : public PadRcv {
	friend SigBit;
	friend NrtxProcess;
	friend UnixProcess;
	friend HostProcess;
	Core	*core;
	Pad	*pad;
	long	mask;
	long	exechang;
	long	numlines;

	long	bit(long s)		{ return 1<<(s-1); }
	void	signalmask(long);
	void	setsig(long);
	void	clrsig(long);
	void	clrcurrsig(long);
	void	sendsig(long);
	void	open();
	void	execline(long);
	void	updatecore(char* =0);
PUBLIC(SigMask,U_SIGMASK)
		SigMask(Core*);
	void	linereq(long,Attrib=0);
	void	hostclose();
	void	banner();
	char	*help(long);
};

class SigBit : public PadRcv { friend SigMask;
	int	bit;
	void	set(SigMask*);
	void	clr(SigMask*);
	void	send(SigMask*);
		SigBit() {}
};
#endif
